<?php
/**
* 
* @package tx
* @author theme-x
* @link https://theme-x.org/
*
* Template Name: Team
*
*/
global $tx;
get_header();
?>

<div class="container space-content">
	<div class="row">
		<?php tx_content_page(); ?>
		<?php
		global $tx;
		if ( get_query_var('paged') ) :
	      $paged = get_query_var('paged');
		elseif ( get_query_var('page') ) :
		      $paged = get_query_var('page');
		else :
		      $paged = 1;
		endif;
		
		$args = array(
	      'post_type' => 'team',
	      'posts_per_page' => $tx['team-per-page'],
	      'paged' => $paged
	    );

		$query = new WP_Query( $args ); ?>
  		<?php if ( $query->have_posts() ) : ?>
  	 	
  		
		<?php while ( $query->have_posts() ) : $query->the_post(); ?>
			<div class="col-lg-3 col-xs-12 col-sm-6">
				<div class="team <?php echo esc_attr($tx['team_display']); ?>">
				<figure>
					<a href="<?php the_permalink(); ?>" rel="bookmark">
					<?php the_post_thumbnail('tx-t-thumb'); ?>		
					<?php if('grid_t' === $tx['team_display']): ?>
					<figcaption>
						<h4><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a></h4>
						<?php
							global $post;
					        $terms = get_the_terms( $post->ID, 'team-category' );
					        if ( $terms && ! is_wp_error( $terms ) ) :
					          $taxonomy = array();
					          foreach ( $terms as $term ) :
					            $taxonomy[] = $term->name;
					          endforeach;
					          $cat_name = join( " ", $taxonomy);
					          $cat_link = get_term_link( $term );
					      else:
					      	$cat_name = '';
					      	endif;
						?>
						<?php if(!empty($cat_name)) : ?>
						<p class="team-cat"><a href="<?php echo esc_url($cat_link); ?>"><?php echo esc_html($cat_name); ?></a></p>
						<?php endif; ?>

						<div class="team-bio"><?php echo tx_excerpt_limit(15); ?></div>
						<?php do_action('tx_single_team_social_icons'); ?>
					</figcaption>
					<?php endif; ?>
					</a>
					<?php if( 'card_t' === $tx['team_display'] ) : ?>
						<div class="tx-team-card">
							<h4><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a></h4>
						<?php
							global $post;
					        $terms = get_the_terms( $post->ID, 'team-category' );
					        if ( $terms && ! is_wp_error( $terms ) ) :
					          $taxonomy = array();
					          foreach ( $terms as $term ) :
					            $taxonomy[] = $term->name;
					          endforeach;
					          $cat_name = join( " ", $taxonomy);
					          $cat_link = get_term_link( $term );
					      else:
					      	$cat_name = '';
					      	endif;
						?>
						<?php if(!empty($cat_name)) : ?>
						<p class="team-cat"><a href="<?php echo esc_url($cat_link); ?>"><?php echo esc_html($cat_name); ?></a></p>
						<?php endif; ?>

						<div class="team-bio"><?php echo tx_excerpt_limit(15); ?></div>
						<?php do_action('tx_single_team_social_icons'); ?>
						</div>
					<?php endif; ?>
				</figure>
				</div><!-- team -->
			</div>	<!-- col-lg-3 col-xs-12 col-sm-6 -->
		<?php endwhile; ?>
 		
	    
		<?php wp_reset_postdata(); ?>

		<?php else:  ?>
	    <?php get_template_part('template-parts/content/content', 'none'); ?>
	  	<?php endif; ?>
	  	<div class="tx-clear"></div>
	  	<!-- pagination -->
		<?php tx_pagination_number($query->max_num_pages,"",$paged); ?>

</div>
</div>
<?php get_footer(); ?>
